SELECT
CASE WHEN fr.Kostensoort <> 'A' THEN 2 ELSE 3 END AS Volgorde,
COALESCE (ob.Uitvoeringsdatum,ob.BezoekDatum) AS Datum,
CASE WHEN fr.Kostensoort = 'A' THEN  'arbeidsloon'
     ELSE LOWER(fr.Omschrijving)      END AS Omschrijving,
CASE WHEN fr.Kostensoort <> 'A' THEN TOSTRING(fr.Aantal) END AS Aantal,
fr.DBRegeltotaal,
fr.volgnr
INTO #TMPRegels
FROM Facturen f

LEFT JOIN Opdrachtbonnen ob ON ( ob.Gefaktureerd=f.Faktuurnr)
INNER JOIN Opdrachtbonregels fr ON ( fr.Opdrachtbonnr=ob.Opdrachtbonnr)
WHERE f.Faktuurnr={keyvalue}
ORDER BY  fr.volgnr, fr.Datum  ;

SELECT
1 AS Volgorde,
COALESCE (ob.Uitvoeringsdatum,ob.BezoekDatum) AS Datum,
CASE WHEN ob.Uitvoeringsdatum IS NULL AND ob.Bezoekdatum IS NULL THEN UPPER(ob.Omschrijving) ELSE
  DATESTRING(COALESCE (ob.Uitvoeringsdatum,ob.BezoekDatum))||' '||UPPER(ob.Omschrijving) END AS Omschrijving,
'' AS Aantal,
CAST (null as Float) as DBRegeltotaal,
0 as volgnr
INTO  #TMPOB
FROM Facturen f
LEFT JOIN Opdrachtbonnen ob ON ( ob.Gefaktureerd=f.Faktuurnr)
WHERE f.Faktuurnr={keyvalue} ;

SELECT
4 AS Volgorde,
COALESCE (ob.Uitvoeringsdatum,ob.BezoekDatum) AS Datum,
'' AS Omschrijving,
'' AS Aantal,
CAST (null as Float) as DBRegeltotaal,
0 as volgnr
INTO  #TMPLEEG
FROM Facturen f
LEFT JOIN Opdrachtbonnen ob ON ( ob.Gefaktureerd=f.Faktuurnr)
WHERE f.Faktuurnr={keyvalue} ;

SELECT *
INTO #TMPTotaal FROM (
SELECT * FROM #TMPRegels
UNION ALL
SELECT * FROM #TMPOB
UNION ALL
SELECT * FROM #TMPLEEG);

SELECT
Volgorde,
Datum,
Omschrijving,
Aantal,
(CAST(SUM(DBRegeltotaal)AS MONEY)) AS Totaal,
volgnr

FROM #TMPTotaal
GROUP BY Volgorde,Datum,Omschrijving,Aantal, volgnr
ORDER BY Datum, Volgorde,volgnr
